/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PFont;
import processing.video.Capture;

public class FBBW04_Cycling_Bit_Sum_Match
extends PApplet {
    Capture camera;
    String title = "Cycling Bit Sum Match";
    int cameraWidth = 640;
    int cameraHeight = 480;
    int numDots = this.cameraWidth * this.cameraHeight;
    Dot[] myDots = new Dot[this.numDots];
    int srcPos;
    int reversedPos;
    int black = this.color(0);
    int white = this.color(255);
    int sampleColor;
    int bitIndex = 0;
    int bitTotal;
    int numBits = 8;
    int bitThreshold = this.numBits / 2;
    int rc;
    int gc;
    int bc;
    int grayscale;
    boolean recordFlag = false;
    PFont font12;
    PFont font12B;
    PFont font24;

    public void setup() {
        this.size(640, 530, "processing.core.PGraphics3D");
        this.frameRate(30.0f);
        this.camera = new Capture((PApplet)this, this.cameraWidth, this.cameraHeight, 30);
        for (int i = 0; i < this.cameraHeight; ++i) {
            for (int j = 0; j < this.cameraWidth; ++j) {
                this.srcPos = i * this.cameraWidth + j;
                this.reversedPos = i * this.cameraWidth + (this.cameraWidth - j - 1);
                this.myDots[this.srcPos] = new Dot(this.srcPos, this.reversedPos);
            }
        }
        this.textMode(256);
        this.font12 = this.loadFont("Courier-12.vlw");
        this.font12B = this.loadFont("Courier-Bold-12.vlw");
        this.font24 = this.loadFont("Courier-24.vlw");
        this.fill(0);
        this.rect(0.0f, this.cameraHeight, this.cameraWidth, this.height - this.cameraHeight);
        this.fill(255);
        this.textAlign(37);
        this.textFont(this.font12B);
        this.text("False Binaries (Black & White)", 8.0f, this.cameraHeight + 22);
        this.textFont(this.font12);
        this.text(this.title, 8.0f, this.cameraHeight + 37);
        this.textAlign(39);
        this.textFont(this.font12);
        this.text("2008 (DEMO)", this.width - 8, this.cameraHeight + 22);
        this.text("Chris Basmajian", this.width - 8, this.cameraHeight + 37);
        this.frame.setTitle(this.title);
        this.noCursor();
    }

    public void draw() {
        if (this.camera.available()) {
            this.camera.read();
        }
        this.loadPixels();
        this.bitThreshold = (this.bitThreshold + 1) % this.numBits;
        int n = 0;
        for (int i = 0; i < this.cameraHeight; ++i) {
            for (int j = 0; j < this.cameraWidth; ++j) {
                this.rc = this.camera.pixels[this.myDots[n].videoIndex] >> 16 & 0xFF;
                this.gc = this.camera.pixels[this.myDots[n].videoIndex] >> 8 & 0xFF;
                this.bc = this.camera.pixels[this.myDots[n].videoIndex] & 0xFF;
                this.grayscale = PApplet.parseInt((float)(0.299f * (float)this.rc + 0.587f * (float)this.gc + 0.114f * (float)this.bc));
                this.sampleColor = this.color(this.grayscale);
                this.bitTotal = 0;
                for (int k = 0; k < 8; ++k) {
                    if ((this.sampleColor >> k & 1) != 1) continue;
                    ++this.bitTotal;
                }
                this.pixels[this.myDots[n].dotIndex] = this.bitTotal == this.bitThreshold ? this.white : this.black;
                ++n;
            }
        }
        this.updatePixels();
        if (this.recordFlag) {
            this.saveFrame("save/frame-#####.tif");
        }
    }

    public void keyPressed() {
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"FBBW04_Cycling_Bit_Sum_Match"});
    }

    class Dot {
        int currPixelColor;
        int prevPixelColor;
        int dotIndex;
        int videoIndex;

        Dot(int n, int n2) {
            this.dotIndex = n;
            this.videoIndex = n2;
            this.prevPixelColor = this.currPixelColor = FBBW04_Cycling_Bit_Sum_Match.this.camera.pixels[this.videoIndex] >> 16 & 0xFF;
        }
    }
}

